/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.renderers.table;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.psw.wcl.components.table.ITableColumnModel;
import com.ibm.psw.wcl.components.table.WTable;
import com.ibm.psw.wcl.components.table.WTableColumn;
import com.ibm.psw.wcl.components.table.WTableComponent;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.cell.AWCell;
import com.ibm.psw.wcl.core.cell.CellInfo;
import com.ibm.psw.wcl.core.renderer.ICellRenderer;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.core.renderer.output.html.HTMLDocumentFragmentWrapper;
import com.ibm.psw.wcl.core.renderer.output.html.IHTMLDocumentFragmentOutput;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.renderers.table.html.HTMLTableRenderer;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLDivElement;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLImageElement;
import org.w3c.dom.html.HTMLInputElement;
import org.w3c.dom.html.HTMLScriptElement;
import org.w3c.dom.html.HTMLStyleElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class CustomHTMLTableRenderer
extends HTMLTableRenderer {
    private static final String TRACE_MASKT = "XWCLHTRT";
    private static final String TRACE_MASKF = "XWCLHTRF";
    private static final String TRACE_MASKD = "XWCLHTRD";

    public IOutput render(RenderingContext rc, Object renderObject) throws RendererException {
        Trace.trace(TRACE_MASKT, ">> render()");
        HTMLDocumentFragmentWrapper doc = rc.getDocumentFactory().createHTMLDocumentFragmentWrapper();
        IOutput io = null;
        if (renderObject instanceof WTable) {
            Trace.trace(TRACE_MASKF, "... render WTable ...");
            HTMLTableElement tableContainer = null;
            HTMLTableElement tableBorder = null;
            HTMLTableSectionElement tb = null;
            HTMLTableRowElement tr = null;
            HTMLTableCellElement td = null;
            WTable wtable = (WTable)renderObject;
            HTMLAnchorElement anchor = doc.createAElement();
            anchor.setName(this.makeUnique(rc, "tableTop", wtable));
            doc.appendToContentFragment((Node)anchor);
            HTMLScriptElement script = doc.createSCRIPTElement();
            String js = rc.getResourceURL("com/ibm/psw/wcl/renderers/scripts/js/WUtilities.js");
            script.setType("text/javascript");
            script.setSrc(js);
            script.appendChild(doc.createTextNode(""));
            doc.appendToHeadFragment((Node)script);
            doc.makeElementReusable((Element)script, "WUTILITIES_SCRIPT");
            script = doc.createSCRIPTElement();
            js = rc.getResourceURL("com/ibm/psw/wcl/renderers/scripts/js/WClient.js");
            script.setType("text/javascript");
            script.setSrc(js);
            script.appendChild(doc.createTextNode(""));
            doc.appendToHeadFragment((Node)script);
            doc.makeElementReusable((Element)script, "WCLIENT_SCRIPT");
            tableContainer = doc.createTABLEElement();
            tableContainer.setBorder("0");
            tableContainer.setWidth("100%");
            tableContainer.setCellPadding("0");
            tableContainer.setCellSpacing("0");
            tableContainer.setSummary(wtable.getDescription());
            this.renderDirection(rc, (WComponent)wtable, tableContainer);
            tableBorder = doc.createTABLEElement();
            tableBorder.setBorder("1");
            tableBorder.setCellPadding("0");
            tableBorder.setCellSpacing("0");
            tableBorder.setWidth("100%");
            tableBorder.setAttribute("style", "border-width:1px 1px 0px 1px;table-layout:auto;");
            this.renderCssStyles(rc, (WComponent)wtable, tableBorder, "tbl1");
            tb = doc.createTBODYElement();
            tr = doc.createTRElement();
            td = doc.createTDElement();
            tableContainer.appendChild(tb);
            tb.appendChild(tr);
            tr.appendChild(td);
            td.appendChild(tableBorder);
            if (wtable.isHeaderVisible()) {
                tableBorder.appendChild(this.createTableHeaderRow(rc, doc, wtable));
            }
            if (this.rowsDisplayable(wtable)) {
                tableBorder.appendChild(this.createTableDataRows(rc, doc, wtable));
            }
            if (wtable.isFooterVisible()) {
                td.appendChild(this.createTableFooter(rc, doc, wtable));
            }
            ((IHTMLDocumentFragmentOutput)wtable.getTableComponent("action").getOutput(rc)).appendContentFragment((Node)tableBorder);
            doc.appendToContentFragment((Node)tableContainer);
            io = doc.createOutput(rc);
        } else if (renderObject instanceof WTableComponent) {
            Trace.trace(TRACE_MASKF, "... render WTableComponent ...");
            WTableComponent wtableComp = (WTableComponent)renderObject;
            WTable wtable = wtableComp.getTable();
            switch (wtableComp.getType()) {
                case 1: {
                    doc.appendToContentFragment(this.createTableToolBar(rc, doc, wtable));
                    break;
                }
                case 2: {
                    doc.appendToContentFragment(this.createTableList(rc, doc, wtable));
                }
            }
            io = doc.createOutput(rc);
        } else {
            throw new RendererException("Render object is not a WTable or a WTableComponent.");
        }
        Trace.trace(TRACE_MASKT, ">> render()");
        return io;
    }

    protected Node createTableHeaderRow(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WTable wtable) throws RendererException {
        ResourceBundle tableResources = this.getResourceBundle(rc, wtable);
        HTMLTableSectionElement tb = null;
        Object tr = null;
        Object th = null;
        Object anchor = null;
        Object image = null;
        ITableColumnModel cm = wtable.getColumnModel();
        int selectedColumn = wtable.getSelectedColumn();
        tb = doc.createTBODYElement();
        tb.setId(this.makeUnique(rc, "H1B", wtable));
        tb.appendChild(this.createTableColumnHeaderRow(rc, doc, wtable, false));
        return tb;
    }

    protected Node createTableColumnHeaderRow(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WTable wtable, boolean inActionBar) throws RendererException {
        HTMLTableRowElement row = null;
        HTMLTableCellElement th = null;
        HTMLAnchorElement anchor = null;
        HTMLImageElement image = null;
        HTMLTableRowElement tr = null;
        HTMLTableCellElement td = null;
        Object div = null;
        HTMLTableElement table = null;
        ITableColumnModel cm = wtable.getColumnModel();
        int selectedColumn = wtable.getSelectedColumn();
        row = doc.createTRElement();
        for (int c = 0; c < wtable.getColumnCount(); ++c) {
            WTableColumn tc = cm.getColumn(c);
            if (!tc.isDisplayable()) continue;
            th = doc.createTHElement();
            table = doc.createTABLEElement();
            tr = doc.createTRElement();
            td = doc.createTDElement();
            table.setBorder("0");
            table.setWidth("100%");
            table.setCellPadding("0");
            table.setCellSpacing("0");
            table.setAttribute("style", "table-layout:auto;");
            td.setTitle(wtable.getColumnName(c));
            td.appendChild(doc.createMarkupTextNode("&nbsp;" + wtable.getColumnName(c) + "&nbsp;"));
            td.setNoWrap(true);
            th.appendChild(table);
            table.appendChild(tr);
            tr.appendChild(td);
            th.setNoWrap(true);
            th.setId(tc.getID());
            if (tc.getPreferredWidth() > 0) {
                th.setWidth(String.valueOf(tc.getPreferredWidth()));
            }
            if (inActionBar) {
                this.renderCssStyles(rc, (WComponent)wtable, th, "tbl14");
            } else {
                this.renderCssStyles(rc, (WComponent)tc, th, c == selectedColumn && wtable.isFilterRowVisible() ? "tcm2" : "tcm1");
            }
            if (wtable.isFeatureEnabled(1) && (c != wtable.getSelectedColumn() || !wtable.isFilterRowVisible()) && tc.isSortable()) {
                if (wtable.isColumnSorted(c)) {
                    int pos = wtable.getSortedColumnIndex(c);
                    int size = wtable.getSortedColumnCount();
                    if (pos > -1 && size > 1) {
                        ++pos;
                    }
                    if (tc.isSortedAscending()) {
                        image = this.createImageTag(rc, doc, wtable, "IMG_TABLE_SORT_ASCENDING_" + pos, "ALT_TAG_IMAGE_SORT_ASCENDING", "absmiddle", false);
                        anchor = this.createAnchorTag(rc, doc, wtable, "toggleSort(" + c + ")", "WTableSortAscending");
                    } else {
                        image = this.createImageTag(rc, doc, wtable, "IMG_TABLE_SORT_DESCENDING_" + pos, "ALT_TAG_IMAGE_SORT_DESCENDING", "absmiddle", false);
                        anchor = this.createAnchorTag(rc, doc, wtable, "toggleSort(" + c + ")", "WTableSortDescending");
                    }
                } else {
                    image = this.createImageTag(rc, doc, wtable, "IMG_TABLE_NOT_SORTED", "ALT_TAG_IMAGE_NOT_SORTED", "absmiddle", false);
                    anchor = this.createAnchorTag(rc, doc, wtable, "toggleSort(" + c + ")", "WTableSortNone");
                }
                tr.appendChild(td);
                td = doc.createTDElement();
                td.setWidth(image.getWidth());
                anchor.appendChild(image);
                td.appendChild(anchor);
            }
            tr.appendChild(td);
            row.appendChild(th);
        }
        return row;
    }

    protected Node createTableDataRows(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WTable wtable) throws RendererException {
        WTableColumn tc;
        int c;
        int r;
        HTMLTableSectionElement tb = null;
        HTMLTableRowElement tr = null;
        HTMLTableCellElement td = null;
        HTMLInputElement input = null;
        HTMLAnchorElement anchor = null;
        HTMLImageElement image = null;
        HTMLDivElement div = null;
        HTMLTableElement table = null;
        ITableColumnModel cm = wtable.getColumnModel();
        int lastModelSelection = wtable.getLastSelectedModelRow();
        int lastViewSelection = lastModelSelection != -1 ? wtable.getViewRowIndex(lastModelSelection) : -1;
        int currentPage = wtable.getCurrentPage();
        int pageStartIndex = wtable.getFirstVisibleRow();
        int pageEndIndex = wtable.getLastVisibleRow();
        int rowsPerView = wtable.getRowsPerViewport();
        tb = doc.createTBODYElement();
        tb.setId(this.makeUnique(rc, "DB", wtable));
        for (r = pageStartIndex; r < pageEndIndex; ++r) {
            tr = doc.createTRElement();
            for (c = 0; c < wtable.getColumnCount(); ++c) {
                tc = cm.getColumn(c);
                if (!tc.isDisplayable()) continue;
                ICellRenderer renderer = wtable.getCellRenderer(rc.getRendererInfo(), r, c);
                AWCell cell = wtable.getCell(r, c);
                CellInfo info = wtable.getCellInfo(r, c);
                td = doc.createTDElement();
                div = doc.createDIVElement();
                if (tc.getModelIndex() == Integer.MAX_VALUE) {
                    if (lastViewSelection - r == 2) {
                        anchor = doc.createAElement();
                        anchor.setName(this.makeUnique(rc, "selectedRow", wtable));
                        td.appendChild(anchor);
                    } else if (wtable.isActionbarVisible() && wtable.getSelectedRowCount() > 0 && r - pageStartIndex > 1 && r == lastViewSelection) {
                        tb.appendChild(this.createTableActionBar(rc, doc, wtable));
                    }
                }
                td.setHeaders(tc.getID());
                td.appendChild(div);
                if (tc.getModelIndex() == Integer.MAX_VALUE) {
                    boolean radio;
                    boolean selected = (Boolean)info.getValue();
                    boolean bl = radio = wtable.getModel().getSelectionMode() == 0;
                    if (wtable.isFeatureEnabled(32)) {
                        image = radio ? (selected ? this.createImageTag(rc, doc, wtable, "IMG_TABLE_RADIO_ON", "ALT_TAG_IMAGE_RADIO_ON", "absmiddle", false) : this.createImageTag(rc, doc, wtable, "IMG_TABLE_RADIO_OFF", "ALT_TAG_IMAGE_RADIO_OFF", "absmiddle", false)) : (selected ? this.createImageTag(rc, doc, wtable, "IMG_TABLE_SELECT_ON", "ALT_TAG_IMAGE_SELECT_ON", "absmiddle", false) : this.createImageTag(rc, doc, wtable, "IMG_TABLE_SELECT_OFF", "ALT_TAG_IMAGE_SELECT_OFF", "absmiddle", false));
                        anchor = this.createAnchorTag(rc, doc, wtable, "select(" + r + ")", radio ? "WTableSingleSelection" : "WTableMultiSelect", this.makeUnique(rc, r - pageStartIndex < 2 || wtable.isRowSelected(r) && wtable.getSelectedRowCount() == 1 ? "tableTop" : "selectedRow", wtable));
                        anchor.appendChild(image);
                        div.appendChild(anchor);
                        cell.setHorizontalAlignment(1);
                    } else {
                        input = doc.createINPUTElement(radio ? "Radio" : "CheckBox");
                        input.setChecked(selected);
                        input.setName(this.makeUnique(rc, "client-select", wtable));
                        input.setValue("" + r);
                        input.setAttribute("onClick", radio ? "return doRTgl(this);" : "return doTgl(this);");
                        input.setAttribute("onFocus", CustomHTMLTableRenderer.getFDAOnFocus((RenderingContext)rc, (WComponent)wtable, (String)(radio ? "WTableSingleSelection" : "WTableMultiSelect")));
                        input.setAttribute("onBlur", CustomHTMLTableRenderer.getFDAOnBlur((RenderingContext)rc, (WComponent)wtable));
                        div.appendChild(input);
                        cell.setHorizontalAlignment(1);
                    }
                } else {
                    IOutput o = renderer.renderCell(rc, cell, info);
                    ((IHTMLDocumentFragmentOutput)o).appendContentFragment((Node)div);
                    ((IHTMLDocumentFragmentOutput)o).appendHeadFragment((Node)doc.getHeadFragment());
                }
                td.setNoWrap(cell.getNoWrap());
                this.renderTableRowCssStyles(rc, doc, wtable, td, info.getSelected());
                this.renderCssStyles(rc, (WComponent)cell, div, "cel1");
                tr.appendChild(td);
            }
            tb.appendChild(tr);
        }
        for (r = pageEndIndex - pageStartIndex; r < wtable.getMinimumRowsDisplayed(); ++r) {
            tr = doc.createTRElement();
            for (c = 0; c < wtable.getColumnCount(); ++c) {
                tc = cm.getColumn(c);
                if (!tc.isDisplayable()) continue;
                td = doc.createTDElement();
                td.appendChild(doc.createMarkupTextNode("&nbsp;"));
                this.renderCssStyles(rc, (WComponent)wtable, td, wtable.isFeatureEnabled(8) ? "tbl2" : "tbl3");
                tr.appendChild(td);
            }
            tb.appendChild(tr);
        }
        table = doc.createTABLEElement();
        div = doc.createDIVElement();
        tb.setAttribute("RPV", String.valueOf(wtable.getRowsPerViewport()));
        tb.setAttribute("SPID", this.makeUnique(rc, "DD", wtable));
        tb.setAttribute("ABID", this.makeUnique(rc, "AB", wtable));
        tb.setAttribute("DR", String.valueOf(wtable.getLastVisibleRow() - wtable.getFirstVisibleRow()));
        return tb;
    }

    protected void renderTableRowCssStyles(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WTable wtable, HTMLElement td, boolean selected) throws RendererException {
        String className;
        AStyleInfo si = this.getStyleInfo(rc, (WComponent)wtable);
        String did = wtable.isFeatureEnabled(8) ? "tbl2" : "tbl3";
        String sdid = wtable.isFeatureEnabled(8) ? "tbls2" : "tbls3";
        String string = className = selected ? sdid : did;
        if (si != null) {
            HTMLStyleElement style = doc.createSTYLEElement();
            style.setType("text/css");
            style.appendChild(doc.createTextNode("." + wtable.makeUnique(did) + " {" + si.getCssString(rc, did) + "}"));
            style.appendChild(doc.createTextNode("." + wtable.makeUnique(sdid) + " {" + si.getCssString(rc, sdid) + "}"));
            doc.appendToHeadFragment((Node)style);
            doc.makeElementReusable((Element)style, wtable.makeUnique("wclTableCustomStyle"));
            td.setClassName(wtable.makeUnique(className));
        } else if (rc.getSkin() != null) {
            td.setClassName(className);
        }
    }

    protected boolean rowsDisplayable(WTable wtable) {
        boolean displayable = !wtable.isCollapsed() && wtable.getLastVisibleRow() - wtable.getFirstVisibleRow() > 0 && this.getFillerColsSpan(wtable) <= wtable.getColumnCount();
        return displayable;
    }

    protected int getFillerColsSpan(WTable wtable) {
        int colspan = wtable.getColumnCount() + 1;
        Enumeration e = wtable.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            if (!((WTableColumn)e.nextElement()).isDisplayable()) continue;
            --colspan;
        }
        return colspan;
    }
}

